# Quick Reference Guide

## 🚀 Quick Start Commands

```bash
# Initial setup
composer install && npm install
cp .env.example .env
php artisan key:generate
php artisan migrate
npm run dev

# Start development (all services)
composer run dev
```

## 📦 Package Management

```bash
# PHP packages
composer require package/name
composer require --dev package/name

# Node packages
npm install package-name
npm install -D package-name
```

## 🗄️ Database

```bash
# Migrations
php artisan migrate
php artisan migrate:rollback
php artisan migrate:fresh
php artisan migrate:fresh --seed

# Seeders
php artisan db:seed
php artisan db:seed --class=ExampleSeeder
```

## 🧪 Testing

```bash
php artisan test
php artisan test --filter TestName
php artisan test --coverage
```

## 🎨 Code Quality

```bash
# Format code
./vendor/bin/pint

# Check formatting
./vendor/bin/pint --test
```

## 🧹 Cache & Optimization

```bash
# Clear all caches
php artisan optimize:clear

# Individual clears
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## 🔐 Authentication & JWT

```bash
# Generate JWT secret
php artisan jwt:secret

# Clear JWT cache
php artisan config:clear
```

## 📝 Artisan Commands

```bash
# Create model
php artisan make:model ModelName -m

# Create controller
php artisan make:controller ControllerName

# Create migration
php artisan make:migration create_table_name

# Create seeder
php artisan make:seeder SeederName

# Create Filament resource
php artisan make:filament-resource ResourceName
```

## 🌐 API

```bash
# Generate Swagger docs
php artisan l5-swagger:generate

# Test API endpoints
curl http://localhost:8000/api/base/health
```

## 🔄 Queue

```bash
# Process queue
php artisan queue:work

# Listen (development)
php artisan queue:listen

# Failed jobs
php artisan queue:failed
php artisan queue:retry all
```

## 📦 Frontend

```bash
# Development
npm run dev

# Production build
npm run build

# Watch mode
npm run dev -- --watch
```

## 🐳 Docker (Sail)

```bash
# Start Sail
./vendor/bin/sail up -d

# Run commands in Sail
./vendor/bin/sail artisan migrate
./vendor/bin/sail npm install
```

## 📊 Useful URLs

- **API**: http://localhost:8000/api
- **Admin**: http://localhost:8000/admin
- **API Docs**: http://localhost:8000/api/documentation
- **Health Check**: http://localhost:8000/api/base/health

## 🔍 Debugging

```bash
# View logs
tail -f storage/logs/laravel.log

# Laravel Pail (if installed)
php artisan pail

# Tinker (interactive shell)
php artisan tinker
```

## 📁 Important Files

- `.env` - Environment configuration
- `routes/api.php` - API routes
- `app/Models/` - Eloquent models
- `database/migrations/` - Database schema
- `config/` - Configuration files

