<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class PlanSeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $en = Language::query()->where('code', 'en')->value('id');
            $zh = Language::query()->where('code', 'zh')->value('id');
            $jf = Company::query()->where('slug', 'jf')->value('id');
            $allianz = Company::query()->where('slug', 'allianz')->value('id');
            $manulife = Company::query()->where('slug', 'manulife')->value('id');
            $_21stCentury = Company::query()->where('slug', '21st-century')->value('id');
            $plans = [
                $jf           => [
                    [
                        'slug'          => 'jf-with',
                        'nameEn'        => 'SMC',
                        'nameZh'        => 'SMC',
                        'descriptionEn' => 'With stable pre-existing conditions coverage option',
                        'descriptionZh' => '具有稳定的既往病史保障选项',
                    ],
                    [
                        'slug'          => 'jf-without',
                        'nameEn'        => 'No-SMC',
                        'nameZh'        => '无SMC',
                        'descriptionEn' => 'Without stable pre-existing conditions coverage option',
                        'descriptionZh' => '无稳定的既往病史保障选项',
                    ],
                ],
                $allianz      => [
                    [
                        'slug'          => 'allianz-with',
                        'nameEn'        => 'SMC',
                        'nameZh'        => 'SMC',
                        'descriptionEn' => 'With stable pre-existing conditions coverage option',
                        'descriptionZh' => '具有稳定的既往病史保障选项',
                    ],
                    [
                        'slug'          => 'allianz-without',
                        'nameEn'        => 'No-SMC',
                        'nameZh'        => '无SMC',
                        'descriptionEn' => 'Without stable pre-existing conditions coverage option',
                        'descriptionZh' => '无稳定的既往病史保障选项',
                    ],
                ],
                $manulife     => [
                    [
                        'slug'          => 'manulife-with',
                        'nameEn'        => 'SMC',
                        'nameZh'        => 'SMC',
                        'descriptionEn' => 'With stable pre-existing conditions coverage option',
                        'descriptionZh' => '具有稳定的既往病史保障选项',
                    ],
                    [
                        'slug'          => 'manulife-without',
                        'nameEn'        => 'No-SMC',
                        'nameZh'        => '无SMC',
                        'descriptionEn' => 'Without stable pre-existing conditions coverage option',
                        'descriptionZh' => '无稳定的既往病史保障选项',
                    ],
                ],
                $_21stCentury => [
                    [
                        'slug'          => '21st-century-basic',
                        'nameEn'        => 'Basic',
                        'nameZh'        => '基本的',
                        'descriptionEn' => 'Basic',
                        'descriptionZh' => '基本的',
                    ],
                    [
                        'slug'          => '21st-century-standard',
                        'nameEn'        => 'Standard',
                        'nameZh'        => '标准',
                        'descriptionEn' => 'Standard',
                        'descriptionZh' => '标准',
                    ],
                    [
                        'slug'          => '21st-century-enhanced',
                        'nameEn'        => 'Enhanced',
                        'nameZh'        => '增强型',
                        'descriptionEn' => 'Enhanced',
                        'descriptionZh' => '增强型',
                    ],
                ],
            ];
            foreach ($plans as $companyId => $companyPlans) {
                $sort = 1;
                foreach ($companyPlans as $plan) {
                    $planId = DB::table('plans')->insertGetId([
                        'company_id' => $companyId,
                        'slug'       => $plan['slug'],
                        'sort'       => $sort++,
                    ]);
                    DB::table('plan_translations')->insert([
                        [
                            'plan_id'     => $planId,
                            'language_id' => $en,
                            'name'        => $plan['nameEn'],
                            'description' => $plan['descriptionEn'],
                        ],
                        [
                            'plan_id'     => $planId,
                            'language_id' => $zh,
                            'name'        => $plan['nameZh'],
                            'description' => $plan['descriptionZh'],
                        ],
                    ]);
                }
            }
        });
    }
}
