<?php

namespace Database\Seeders;

use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class ContentSeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $en = Language::query()->where('code', 'en')->value('id');
            $zh = Language::query()->where('code', 'zh')->value('id');
            $contentsEn = [
                'calculator_form_title'                => 'Travel Medical Insurance Price Check',
                'calculator_form_entry'                => 'Insurance',
                'calculator_form_visiting'             => 'Visiting Canada',
                'calculator_form_travel'               => 'Travel out of Canada',
                'calculator_form_birthday'             => 'Date of Birth',
                'calculator_form_cover'                => 'Benefit',
                'calculator_form_start'                => 'Effective Date',
                'calculator_form_end'                  => 'End Date',
                'calculator_form_error_end'            => 'End date must be at least the same as the effective date.',
                'calculator_form_error_max'            => 'End date must not be more than 365 days after the effective date.',
                'calculator_form_submit'               => 'Check',
                'calculator_result_deductible'         => 'Deductible',
                'calculator_result_deductible_tooltip' => 'Choosing a deductible can get you a corresponding premium discount. When a claim is made, you will need to pay the amount of the deductible you choose before the insurance company pays the remaining expenses. The deductible with an * is a vanishing deductible. A few companies have it. If you choose it, you need to check the corresponding insurance regulations.',
                'calculator_result_unit'               => 'Unit price/day',
                'calculator_result_total'              => 'Total Price',
                'calculator_result_buy'                => 'Buy Online',
                'calculator_result_details'            => 'Click here for detailed terms',
                'inquiry_age'                          => 'Age on purchase date',
                'inquiry_cover'                        => 'Sum Insured',
                'inquiry_days'                         => 'Insurance days',
                'inquiry_back'                         => 'Back',
                'inquiry_next'                         => 'Next',
                'inquiry_step1_title'                  => 'Terms of Service',
                'inquiry_step1_header'                 => 'Terms of Service',
                'inquiry_step1_description'            => <<<EOT
<p><strong>When you agree and purchase the policy, it is assumed that you have understood the policy wording and agreed to the insurance terms.</strong></p>
<p></p>
<p>*After completing the online purchase, you will receive the official electronic policy via email within 1-24 hours</p>
<p>*This website has been highly encrypted by SSL. Our online purchase is safe and fast. Please feel free to use it.</p>
<p>*Before the effective date of the policy, you can cancel the policy at any time without reason or fee (super visa requires a government rejection letter)</p>
<p>*If you have any questions, please consult us in detail before purchase. We provide service 24/7 at any time.</p>
<p>*We assume legal responsibility for the above terms and conditions.</p>

EOT,
                'inquiry_step1_agreement'              => 'Agree to the terms of service.',
                'inquiry_step2_title'                  => 'Basic Information',
                'inquiry_step2_basic'                  => 'Basic Information',
                'inquiry_step2_family'                 => 'Choose a Family Plan',
                'inquiry_step2_no'                     => 'No',
                'inquiry_step2_yes'                    => 'Yes',
                'inquiry_step2_people'                 => 'Number of people who purchased insurance',
                'inquiry_step2_cover'                  => 'Choose the amount of insurance',
                'inquiry_step2_address'                => 'Address in Canada',
                'inquiry_step2_city'                   => 'City',
                'inquiry_step2_province'               => 'Province',
                'inquiry_step2_postalcode'             => 'Postal Code',
                'inquiry_step2_phone'                  => 'Phone Number',
                'inquiry_step2_email'                  => 'Email Address',
                'inquiry_step2_firstname'              => 'First Name',
                'inquiry_step2_lastname'               => 'Last Name',
                'inquiry_step2_gender'                 => 'Gender',
                'inquiry_step2_male'                   => 'Male',
                'inquiry_step2_female'                 => 'Female',
                'inquiry_step2_birthday'               => 'Date of Birthday',
                'inquiry_step2_insured'                => 'Insured Person Information',
                'inquiry_step2_beneficiaries'          => 'Beneficiaries',
                'inquiry_step2_alert'                  => '*The policy includes accidental death and dismemberment. If an accident occurs, the same amount will be paid to the beneficiary.',
                'inquiry_step2_policy'                 => 'Insurance Policy Date',
                'inquiry_step2_start'                  => 'Insurance effective date',
                'inquiry_step2_end'                    => 'Insurance end date',
                'inquiry_step2_arrival'                => 'Arrival date in Canada',
                'inquiry_step2_error_end'              => 'End date must be at least the same as the effective date.',
                'inquiry_step2_error_max'              => 'End date must not be more than 365 days after the effective date.',
                'inquiry_step3_title'                  => 'Confirmation & Payment',
                'inquiry_step3_fullname'               => 'Full Name',
                'inquiry_step3_gender'                 => 'Gender',
                'inquiry_step3_birthday'               => 'Date of Birthday',
                'inquiry_step3_insured'                => 'Insured Person',
                'inquiry_step3_beneficiaries'          => 'Beneficiary/s Person',
                'inquiry_step3_policy'                 => 'Insurance Policy Date',
                'inquiry_step3_start'                  => 'Insurance effective date',
                'inquiry_step3_end'                    => 'Insurance end date',
                'inquiry_step3_arrival'                => 'Arrival date in Canada',
                'inquiry_step3_deductible'             => 'Deductible',
                'inquiry_step3_unit_total'             => 'Unit Price (Total Price)',
                'inquiry_step3_pay'                    => 'Pay',
                'inquiry_step3_methods'                => 'Payment Methods',
                'inquiry_step3_credit'                 => 'Credit Card',
                'inquiry_step3_bank'                   => 'Bank Transfer',
                'inquiry_step3_card_number'            => 'Card Number',
                'inquiry_step3_card_cvv'               => 'CVV',
                'inquiry_step3_card_name'              => 'Name on Card',
                'inquiry_step3_card_expiration'        => 'Expiration',
                'inquiry_step3_error_card_number'      => 'Card number must be between 12 and 19 digits.',
                'inquiry_step3_error_plan'             => 'Plan is required! Please choose a plan.',
                'inquiry_step3_transfer'               => 'You can directly transfer the money via Email-T to (JAYSONX868[AT]GMAIL.COM), provide the transfer password via email or our service WeChat (wuyou868jayson), and inform the name of the purchaser. You will receive the electronic insurance policy within 8 hours.',
                'inquiry_step3_message'                => 'Message',
                'inquiry_step4_title'                  => 'Submit',
                'inquiry_step4_greeting'               => 'Dear',
                'inquiry_step4_message'                => <<<EOT
<p>You have successfully submitted your order. The official electronic insurance policy will be sent to you via email <span style="color:red;">within 24 hours</span>.</p>
<p>If you have any questions or need expedited processing, please feel free to contact us.</p>

EOT,
                'inquiry_step4_thanks'                 => <<<EOT
<p>Thanks for choosing us.</p>
<p>KPJ Insurance</p>

EOT,
                'inquiry_step4_back'                   => 'Back to Home',
            ];
            $contentsZh = [
                'calculator_form_title'                => '旅游保险在线查询',
                'calculator_form_entry'                => '保险类型',
                'calculator_form_visiting'             => '访加探亲旅游保险',
                'calculator_form_travel'               => '加拿大居民旅游保险',
                'calculator_form_birthday'             => '出生日期',
                'calculator_form_cover'                => '选择保额',
                'calculator_form_start'                => '生效日期',
                'calculator_form_end'                  => '结束日期',
                'calculator_form_error_end'            => '结束日期必须至少与生效日期相同。',
                'calculator_form_error_max'            => '结束日期不得晚于生效日期之后 365 天。',
                'calculator_form_submit'               => '在线报价',
                'calculator_result_deductible'         => '垫底费',
                'calculator_result_deductible_tooltip' => '选择垫底费能拿到相应的保费折扣，发生理赔的时候，需要您承担选择的垫底费的数额后，剩余的费用保险公司才赔付，带*号属于消失性垫底费，少部分公司有，如果选择的话需要查看相应保险条例',
                'calculator_result_unit'               => '单价/天',
                'calculator_result_total'              => '总价',
                'calculator_result_buy'                => '在线购买',
                'calculator_result_details'            => '点击此处了解详细条款',
                'inquiry_age'                          => '购买日期时的年龄',
                'inquiry_cover'                        => '保额',
                'inquiry_days'                         => '保险天数',
                'inquiry_back'                         => '上一步',
                'inquiry_next'                         => '下一步',
                'inquiry_step1_title'                  => '服务条款',
                'inquiry_step1_header'                 => '服务条款',
                'inquiry_step1_description'            => <<<EOT
<h3>当您同意并购买保单,默认为您已经了解policy wording并同意保险条款</h3>
<p></p>
<p>*在线完成购买后,您将会在1-24小时内通过邮箱收到正式电子保单</p>
<p>*本网站已经经过SSL高度加密,我们的在线购买是安全并且快捷的,请放心使用</p>
<p>*在保单生效日之前,您随时能无理由无手续费取消保单（超级签证需提供政府拒签信）</p>
<p>*有任何疑问请在购买前详细咨询我们7X24小时随时提供服务</p>
<p>*我们对以上条款承诺承担法律责任</p>

EOT,
                'inquiry_step1_agreement'              => '同意服务条款',
                'inquiry_step2_title'                  => '基本信息',
                'inquiry_step2_basic'                  => '基本信息',
                'inquiry_step2_family'                 => '选择家庭计划',
                'inquiry_step2_no'                     => '否',
                'inquiry_step2_yes'                    => '是的',
                'inquiry_step2_people'                 => '购买保险人数',
                'inquiry_step2_cover'                  => '选择保额',
                'inquiry_step2_address'                => '加拿大住址',
                'inquiry_step2_city'                   => '城市',
                'inquiry_step2_province'               => '省份',
                'inquiry_step2_postalcode'             => '邮编',
                'inquiry_step2_phone'                  => '联系电话',
                'inquiry_step2_email'                  => '电子邮件',
                'inquiry_step2_firstname'              => '姓',
                'inquiry_step2_lastname'               => '名',
                'inquiry_step2_gender'                 => '性别',
                'inquiry_step2_male'                   => '男性',
                'inquiry_step2_female'                 => '女性',
                'inquiry_step2_birthday'               => '出生日期',
                'inquiry_step2_insured'                => '受保人',
                'inquiry_step2_beneficiaries'          => '受益人',
                'inquiry_step2_alert'                  => '*保单包含意外死亡伤残，如发生意外将会赔付同等金额给受益人。',
                'inquiry_step2_policy'                 => '保险日期',
                'inquiry_step2_start'                  => '保险生效日期',
                'inquiry_step2_end'                    => '保险结束日期',
                'inquiry_step2_arrival'                => '抵达加拿大日期',
                'inquiry_step2_error_end'              => '结束日期必须至少与生效日期相同。',
                'inquiry_step2_error_max'              => '结束日期不得晚于生效日期之后 365 天。',
                'inquiry_step3_title'                  => '确认 & 付款',
                'inquiry_step3_fullname'               => '姓名',
                'inquiry_step3_gender'                 => '性别',
                'inquiry_step3_birthday'               => '出生日期',
                'inquiry_step3_insured'                => '受保人',
                'inquiry_step3_beneficiaries'          => '受益人',
                'inquiry_step3_policy'                 => '保险日期',
                'inquiry_step3_start'                  => '保险生效日期',
                'inquiry_step3_end'                    => '保险结束日期',
                'inquiry_step3_arrival'                => '抵达加拿大日期:',
                'inquiry_step3_deductible'             => '垫底费',
                'inquiry_step3_unit_total'             => '单价（总价）',
                'inquiry_step3_pay'                    => '付款',
                'inquiry_step3_methods'                => '付款方式',
                'inquiry_step3_credit'                 => '信用卡',
                'inquiry_step3_bank'                   => '现金',
                'inquiry_step3_card_number'            => 'Card Number',
                'inquiry_step3_card_cvv'               => 'CVV',
                'inquiry_step3_card_name'              => 'Name on Card',
                'inquiry_step3_card_expiration'        => 'Expiration',
                'inquiry_step3_error_card_number'      => '卡号必须介于 12 至 19 位数字之间。',
                'inquiry_step3_error_plan'             => '需要套餐！请选择套餐。',
                'inquiry_step3_transfer'               => '您可以直接Email-T 转账到（JAYSONX868@GMAIL.COM），并通过邮箱或我们的服务微信（wuyou868jayson）提供转账密码，告知购买人姓名，您会在8小时内收到电子保单。',
                'inquiry_step3_message'                => '留言',
                'inquiry_step4_title'                  => '提交',
                'inquiry_step4_greeting'               => '亲爱的',
                'inquiry_step4_message'                => <<<EOT
<p>您已经成功提交订单，正式的电子保单在<span style="color:red;">二十四小时内</span>通过电子邮箱发给您，如果有任何疑问或需要加急处理请随时联系我们。</p>

EOT,
                'inquiry_step4_thanks'                 => <<<EOT
<p>感谢您选择我们。</p>
<p>靠谱君加拿大保险服务</p>

EOT,
                'inquiry_step4_back'                   => '返回首页',
            ];
            DB::table('contents')->insert([
                'language_id' => $en,
                ...$contentsEn,
            ]);
            DB::table('contents')->insert([
                'language_id' => $zh,
                ...$contentsZh,
            ]);
        });
    }
}
