<?php

namespace Database\Seeders;

use App\Models\Language;
use App\Models\Province;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class CitySeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $alberta = Province::query()->where('slug', 'alberta')->value('id');
            $britishColumbia = Province::query()->where('slug', 'british-columbia')->value('id');
            $manitoba = Province::query()->where('slug', 'manitoba')->value('id');
            $newBrunswick = Province::query()->where('slug', 'new-brunswick')->value('id');
            $newfoundlandAndLabrador = Province::query()->where('slug', 'newfoundland-and-labrador')->value('id');
            $novaScotia = Province::query()->where('slug', 'nova-scotia')->value('id');
            $ontario = Province::query()->where('slug', 'ontario')->value('id');
            $princeEdwardIsland = Province::query()->where('slug', 'prince-edward-island')->value('id');
            $quebec = Province::query()->where('slug', 'quebec')->value('id');
            $saskatchewan = Province::query()->where('slug', 'saskatchewan')->value('id');
            $northwestTerritories = Province::query()->where('slug', 'northwest-territories')->value('id');
            $nunavut = Province::query()->where('slug', 'nunavut')->value('id');
            $yukon = Province::query()->where('slug', 'yukon')->value('id');
            $cities = [
                $alberta                 => [
                    [
                        'slug' => 'airdrie',
                        'name' => 'Airdrie',
                    ],
                    [
                        'slug' => 'brooks',
                        'name' => 'Brooks',
                    ],
                    [
                        'slug' => 'calgary',
                        'name' => 'Calgary',
                    ],
                    [
                        'slug' => 'camrose',
                        'name' => 'Camrose',
                    ],
                    [
                        'slug' => 'chestermere',
                        'name' => 'Chestermere',
                    ],
                    [
                        'slug' => 'cold-lake',
                        'name' => 'Cold Lake',
                    ],
                    [
                        'slug' => 'edmonton',
                        'name' => 'Edmonton',
                    ],
                    [
                        'slug' => 'fort-saskatchewan',
                        'name' => 'Fort Saskatchewan',
                    ],
                    [
                        'slug' => 'grande-prairie',
                        'name' => 'Grande Prairie',
                    ],
                    [
                        'slug' => 'lacombe',
                        'name' => 'Lacombe',
                    ],
                    [
                        'slug' => 'leduc',
                        'name' => 'Leduc',
                    ],
                    [
                        'slug' => 'lethbridge',
                        'name' => 'Lethbridge',
                    ],
                    [
                        'slug' => 'lloydminster',
                        'name' => 'Lloydminster',
                    ],
                    [
                        'slug' => 'medicine-hat',
                        'name' => 'Medicine Hat',
                    ],
                    [
                        'slug' => 'red-deer',
                        'name' => 'Red Deer',
                    ],
                    [
                        'slug' => 'spruce-grove',
                        'name' => 'Spruce Grove',
                    ],
                    [
                        'slug' => 'st-albert',
                        'name' => 'St. Albert',
                    ],
                    [
                        'slug' => 'wetaskiwin',
                        'name' => 'Wetaskiwin',
                    ],
                ],
                $britishColumbia         => [
                    [
                        'slug' => 'abbotsford',
                        'name' => 'Abbotsford',
                    ],
                    [
                        'slug' => 'armstrong',
                        'name' => 'Armstrong',
                    ],
                    [
                        'slug' => 'burnaby',
                        'name' => 'Burnaby',
                    ],
                    [
                        'slug' => 'campbell-river',
                        'name' => 'Campbell River',
                    ],
                    [
                        'slug' => 'castlegar',
                        'name' => 'Castlegar',
                    ],
                    [
                        'slug' => 'chilliwack',
                        'name' => 'Chilliwack',
                    ],
                    [
                        'slug' => 'colwood',
                        'name' => 'Colwood',
                    ],
                    [
                        'slug' => 'coquitlam',
                        'name' => 'Coquitlam',
                    ],
                    [
                        'slug' => 'courtenay',
                        'name' => 'Courtenay',
                    ],
                    [
                        'slug' => 'cranbrook',
                        'name' => 'Cranbrook',
                    ],
                    [
                        'slug' => 'dawson-creek',
                        'name' => 'Dawson Creek',
                    ],
                    [
                        'slug' => 'delta',
                        'name' => 'Delta',
                    ],
                    [
                        'slug' => 'duncan',
                        'name' => 'Duncan',
                    ],
                    [
                        'slug' => 'enderby',
                        'name' => 'Enderby',
                    ],
                    [
                        'slug' => 'fernie',
                        'name' => 'Fernie',
                    ],
                    [
                        'slug' => 'fort-st-john',
                        'name' => 'Fort St. John',
                    ],
                    [
                        'slug' => 'grand-forks',
                        'name' => 'Grand Forks',
                    ],
                    [
                        'slug' => 'greenwood',
                        'name' => 'Greenwood',
                    ],
                    [
                        'slug' => 'kamloops',
                        'name' => 'Kamloops',
                    ],
                    [
                        'slug' => 'kelowna',
                        'name' => 'Kelowna',
                    ],
                    [
                        'slug' => 'kimberley',
                        'name' => 'Kimberley',
                    ],
                    [
                        'slug' => 'langford',
                        'name' => 'Langford',
                    ],
                    [
                        'slug' => 'langley',
                        'name' => 'Langley',
                    ],
                    [
                        'slug' => 'maple-ridge',
                        'name' => 'Maple Ridge',
                    ],
                    [
                        'slug' => 'merritt',
                        'name' => 'Merritt',
                    ],
                    [
                        'slug' => 'nanaimo',
                        'name' => 'Nanaimo',
                    ],
                    [
                        'slug' => 'nelson',
                        'name' => 'Nelson',
                    ],
                    [
                        'slug' => 'new-westminster',
                        'name' => 'New Westminster',
                    ],
                    [
                        'slug' => 'north-vancouver',
                        'name' => 'North Vancouver',
                    ],
                    [
                        'slug' => 'parksville',
                        'name' => 'Parksville',
                    ],
                    [
                        'slug' => 'penticton',
                        'name' => 'Penticton',
                    ],
                    [
                        'slug' => 'pitt-meadows',
                        'name' => 'Pitt Meadows',
                    ],
                    [
                        'slug' => 'port-alberni',
                        'name' => 'Port Alberni',
                    ],
                    [
                        'slug' => 'port-coquitlam',
                        'name' => 'Port Coquitlam',
                    ],
                    [
                        'slug' => 'port-moody',
                        'name' => 'Port Moody',
                    ],
                    [
                        'slug' => 'powell-river',
                        'name' => 'Powell River',
                    ],
                    [
                        'slug' => 'prince-george',
                        'name' => 'Prince George',
                    ],
                    [
                        'slug' => 'prince-rupert',
                        'name' => 'Prince Rupert',
                    ],
                    [
                        'slug' => 'quesnel',
                        'name' => 'Quesnel',
                    ],
                    [
                        'slug' => 'revelstoke',
                        'name' => 'Revelstoke',
                    ],
                    [
                        'slug' => 'richmond',
                        'name' => 'Richmond',
                    ],
                    [
                        'slug' => 'rossland',
                        'name' => 'Rossland',
                    ],
                    [
                        'slug' => 'salmon-arm',
                        'name' => 'Salmon Arm',
                    ],
                    [
                        'slug' => 'surrey',
                        'name' => 'Surrey',
                    ],
                    [
                        'slug' => 'terrace',
                        'name' => 'Terrace',
                    ],
                    [
                        'slug' => 'trail',
                        'name' => 'Trail',
                    ],
                    [
                        'slug' => 'vancouver',
                        'name' => 'Vancouver',
                    ],
                    [
                        'slug' => 'vernon',
                        'name' => 'Vernon',
                    ],
                    [
                        'slug' => 'victoria',
                        'name' => 'Victoria',
                    ],
                    [
                        'slug' => 'west-kelowna',
                        'name' => 'West Kelowna',
                    ],
                    [
                        'slug' => 'white-rock',
                        'name' => 'White Rock',
                    ],
                    [
                        'slug' => 'williams-lake',
                        'name' => 'Williams Lake',
                    ],
                ],
                $manitoba                => [
                    [
                        'slug' => 'brandon',
                        'name' => 'Brandon',
                    ],
                    [
                        'slug' => 'dauphin',
                        'name' => 'Dauphin',
                    ],
                    [
                        'slug' => 'flin-flon',
                        'name' => 'Flin Flon',
                    ],
                    [
                        'slug' => 'morden',
                        'name' => 'Morden',
                    ],
                    [
                        'slug' => 'portage-la-prairie',
                        'name' => 'Portage la Prairie',
                    ],
                    [
                        'slug' => 'selkirk',
                        'name' => 'Selkirk',
                    ],
                    [
                        'slug' => 'steinbach',
                        'name' => 'Steinbach',
                    ],
                    [
                        'slug' => 'thompson',
                        'name' => 'Thompson',
                    ],
                    [
                        'slug' => 'winkler',
                        'name' => 'Winkler',
                    ],
                    [
                        'slug' => 'winnipeg',
                        'name' => 'Winnipeg',
                    ],
                ],
                $newBrunswick            => [
                    [
                        'slug' => 'bathurst',
                        'name' => 'Bathurst',
                    ],
                    [
                        'slug' => 'campbellton',
                        'name' => 'Campbellton',
                    ],
                    [
                        'slug' => 'dieppe',
                        'name' => 'Dieppe',
                    ],
                    [
                        'slug' => 'edmundston',
                        'name' => 'Edmundston',
                    ],
                    [
                        'slug' => 'fredericton',
                        'name' => 'Fredericton',
                    ],
                    [
                        'slug' => 'miramichi',
                        'name' => 'Miramichi',
                    ],
                    [
                        'slug' => 'moncton',
                        'name' => 'Moncton',
                    ],
                    [
                        'slug' => 'saint-john',
                        'name' => 'Saint John',
                    ],
                ],
                $newfoundlandAndLabrador => [
                    [
                        'slug' => 'corner-brook',
                        'name' => 'Corner Brook',
                    ],
                    [
                        'slug' => 'mount-pearl',
                        'name' => 'Mount Pearl',
                    ],
                    [
                        'slug' => 'st-johns',
                        'name' => 'St. John’s',
                    ],
                ],
                $novaScotia              => [
                    [
                        'slug' => 'halifax',
                        'name' => 'Halifax',
                    ],
                    [
                        'slug' => 'sydney',
                        'name' => 'Sydney',
                    ],
                ],
                $ontario                 => [
                    [
                        'slug' => 'barrie',
                        'name' => 'Barrie',
                    ],
                    [
                        'slug' => 'belleville',
                        'name' => 'Belleville',
                    ],
                    [
                        'slug' => 'brampton',
                        'name' => 'Brampton',
                    ],
                    [
                        'slug' => 'brant',
                        'name' => 'Brant',
                    ],
                    [
                        'slug' => 'brantford',
                        'name' => 'Brantford',
                    ],
                    [
                        'slug' => 'brockville',
                        'name' => 'Brockville',
                    ],
                    [
                        'slug' => 'burlington',
                        'name' => 'Burlington',
                    ],
                    [
                        'slug' => 'cambridge',
                        'name' => 'Cambridge',
                    ],
                    [
                        'slug' => 'clarence-rockland',
                        'name' => 'Clarence-Rockland',
                    ],
                    [
                        'slug' => 'cornwall',
                        'name' => 'Cornwall',
                    ],
                    [
                        'slug' => 'dryden',
                        'name' => 'Dryden',
                    ],
                    [
                        'slug' => 'elliot-lake',
                        'name' => 'Elliot Lake',
                    ],
                    [
                        'slug' => 'greater-sudbury',
                        'name' => 'Greater Sudbury',
                    ],
                    [
                        'slug' => 'guelph',
                        'name' => 'Guelph',
                    ],
                    [
                        'slug' => 'haldimand-county',
                        'name' => 'Haldimand County',
                    ],
                    [
                        'slug' => 'hamilton',
                        'name' => 'Hamilton',
                    ],
                    [
                        'slug' => 'kawartha-lakes',
                        'name' => 'Kawartha Lakes',
                    ],
                    [
                        'slug' => 'kenora',
                        'name' => 'Kenora',
                    ],
                    [
                        'slug' => 'kingston',
                        'name' => 'Kingston',
                    ],
                    [
                        'slug' => 'kitchener',
                        'name' => 'Kitchener',
                    ],
                    [
                        'slug' => 'london',
                        'name' => 'London',
                    ],
                    [
                        'slug' => 'markham',
                        'name' => 'Markham',
                    ],
                    [
                        'slug' => 'mississauga',
                        'name' => 'Mississauga',
                    ],
                    [
                        'slug' => 'niagara-falls',
                        'name' => 'Niagara Falls',
                    ],
                    [
                        'slug' => 'norfolk-county',
                        'name' => 'Norfolk County',
                    ],
                    [
                        'slug' => 'north-bay',
                        'name' => 'North Bay',
                    ],
                    [
                        'slug' => 'orillia',
                        'name' => 'Orillia',
                    ],
                    [
                        'slug' => 'oshawa',
                        'name' => 'Oshawa',
                    ],
                    [
                        'slug' => 'ottawa',
                        'name' => 'Ottawa',
                    ],
                    [
                        'slug' => 'owen-sound',
                        'name' => 'Owen Sound',
                    ],
                    [
                        'slug' => 'pembroke',
                        'name' => 'Pembroke',
                    ],
                    [
                        'slug' => 'peterborough',
                        'name' => 'Peterborough',
                    ],
                    [
                        'slug' => 'pickering',
                        'name' => 'Pickering',
                    ],
                    [
                        'slug' => 'port-colborne',
                        'name' => 'Port Colborne',
                    ],
                    [
                        'slug' => 'prince-edward-county',
                        'name' => 'Prince Edward County',
                    ],
                    [
                        'slug' => 'quinte-west',
                        'name' => 'Quinte West',
                    ],
                    [
                        'slug' => 'sarnia',
                        'name' => 'Sarnia',
                    ],
                    [
                        'slug' => 'sault-ste-marie',
                        'name' => 'Sault Ste. Marie',
                    ],
                    [
                        'slug' => 'st-catharines',
                        'name' => 'St. Catharines',
                    ],
                    [
                        'slug' => 'st-thomas',
                        'name' => 'St. Thomas',
                    ],
                    [
                        'slug' => 'stratford',
                        'name' => 'Stratford',
                    ],
                    [
                        'slug' => 'temiskaming-shores',
                        'name' => 'Temiskaming Shores',
                    ],
                    [
                        'slug' => 'thorold',
                        'name' => 'Thorold',
                    ],
                    [
                        'slug' => 'thunder-bay',
                        'name' => 'Thunder Bay',
                    ],
                    [
                        'slug' => 'timmins',
                        'name' => 'Timmins',
                    ],
                    [
                        'slug' => 'toronto',
                        'name' => 'Toronto',
                    ],
                    [
                        'slug' => 'vaughan',
                        'name' => 'Vaughan',
                    ],
                    [
                        'slug' => 'waterloo',
                        'name' => 'Waterloo',
                    ],
                    [
                        'slug' => 'welland',
                        'name' => 'Welland',
                    ],
                    [
                        'slug' => 'windsor',
                        'name' => 'Windsor',
                    ],
                    [
                        'slug' => 'woodstock',
                        'name' => 'Woodstock',
                    ],
                ],
                $princeEdwardIsland      => [
                    [
                        'slug' => 'charlottetown',
                        'name' => 'Charlottetown',
                    ],
                    [
                        'slug' => 'summerside',
                        'name' => 'Summerside',
                    ],
                ],
                $quebec                  => [
                    [
                        'slug' => 'gatineau',
                        'name' => 'Gatineau',
                    ],
                    [
                        'slug' => 'laval',
                        'name' => 'Laval',
                    ],
                    [
                        'slug' => 'longueuil',
                        'name' => 'Longueuil',
                    ],
                    [
                        'slug' => 'montreal',
                        'name' => 'Montreal',
                    ],
                    [
                        'slug' => 'quebec-city',
                        'name' => 'Quebec City',
                    ],
                    [
                        'slug' => 'saguenay',
                        'name' => 'Saguenay',
                    ],
                    [
                        'slug' => 'sherbrooke',
                        'name' => 'Sherbrooke',
                    ],
                    [
                        'slug' => 'terrebonne',
                        'name' => 'Terrebonne',
                    ],
                    [
                        'slug' => 'trois-rivieres',
                        'name' => 'Trois-Rivières',
                    ],
                ],
                $saskatchewan            => [
                    [
                        'slug' => 'lloydminster',
                        'name' => 'Lloydminster',
                    ],
                    [
                        'slug' => 'martensville',
                        'name' => 'Martensville',
                    ],
                    [
                        'slug' => 'meadow-lake',
                        'name' => 'Meadow Lake',
                    ],
                    [
                        'slug' => 'melfort',
                        'name' => 'Melfort',
                    ],
                    [
                        'slug' => 'melville',
                        'name' => 'Melville',
                    ],
                    [
                        'slug' => 'moose-jaw',
                        'name' => 'Moose Jaw',
                    ],
                    [
                        'slug' => 'north-battleford',
                        'name' => 'North Battleford',
                    ],
                    [
                        'slug' => 'prince-albert',
                        'name' => 'Prince Albert',
                    ],
                    [
                        'slug' => 'regina',
                        'name' => 'Regina',
                    ],
                    [
                        'slug' => 'saskatoon',
                        'name' => 'Saskatoon',
                    ],
                    [
                        'slug' => 'swift-current',
                        'name' => 'Swift Current',
                    ],
                    [
                        'slug' => 'warman',
                        'name' => 'Warman',
                    ],
                    [
                        'slug' => 'weyburn',
                        'name' => 'Weyburn',
                    ],
                    [
                        'slug' => 'yorkton',
                        'name' => 'Yorkton',
                    ],
                ],
                $northwestTerritories    => [
                    [
                        'slug' => 'yellowknife',
                        'name' => 'Yellowknife',
                    ],
                ],
                $nunavut                 => [
                    [
                        'slug' => 'iqaluit',
                        'name' => 'Iqaluit',
                    ],
                ],
                $yukon                   => [
                    [
                        'slug' => 'whitehorse',
                        'name' => 'Whitehorse',
                    ],
                ],
            ];
            $languageIds = Language::query()->orderBy('id')->pluck('id')->toArray();
            foreach ($cities as $provinceId => $provinceCities) {
                foreach ($provinceCities as $city) {
                    $cityId = DB::table('cities')->insertGetId([
                        'province_id' => $provinceId,
                        'slug'        => $city['slug'] . '-' . $provinceId,
                    ]);
                    foreach ($languageIds as $languageId) {
                        DB::table('city_translations')->insert([
                            'city_id'     => $cityId,
                            'language_id' => $languageId,
                            'name'        => $city['name'],
                        ]);
                    }
                }
            }
        });
    }
}
