// database/migrations/2025_12_13_000000_improve_inquiries_table.php
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('inquiries', function (Blueprint $table) {
            // اضافه کردن فیلدهای مدیریتی
            $table->string('reference_number')->nullable()->unique()->after('id');
            $table->enum('status', ['pending', 'under_review', 'approved', 'rejected', 'completed'])
                  ->default('pending')
                  ->after('is_deal');
            $table->decimal('total_premium', 12, 2)->nullable()->after('insurance_cover');
            $table->integer('number_of_people')->default(1)->after('total_premium');
            
            // فیلدهای زمانی محلی
            $table->dateTime('local_submitted_at')->nullable()->after('reviewed_at');
            
            // برای بیمه خروج (تسک ۱)
            $table->string('destination_country')->nullable()->after('is_entry');
            $table->enum('trip_purpose', ['tourism', 'business', 'education', 'other'])->nullable()->after('destination_country');
            
            // ایندکس‌های جدید
            $table->index(['agent_id', 'inquired_at']);
            $table->index(['status', 'inquired_at']);
            $table->index(['reference_number']);
        });
        
        // اضافه کردن فیلد به جدول people
        Schema::table('people', function (Blueprint $table) {
            $table->string('relationship')->nullable()->after('last_name');
            $table->boolean('is_primary')->default(false)->after('relationship');
            $table->integer('calculated_age')->virtualAs('TIMESTAMPDIFF(YEAR, born_at, CURDATE())')->nullable()->after('born_at');
        });
    }

    public function down(): void
    {
        Schema::table('inquiries', function (Blueprint $table) {
            $table->dropColumn([
                'reference_number', 
                'status', 
                'total_premium', 
                'number_of_people',
                'local_submitted_at',
                'destination_country',
                'trip_purpose'
            ]);
            
            $table->dropIndex(['agent_id', 'inquired_at']);
            $table->dropIndex(['status', 'inquired_at']);
            $table->dropIndex(['reference_number']);
        });
        
        Schema::table('people', function (Blueprint $table) {
            $table->dropColumn(['relationship', 'is_primary', 'calculated_age']);
        });
    }
};