<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('admins', function (Blueprint $table) {
            $table->string('email')->after('name')->nullable()->unique();
        });

        Schema::table('agents', function (Blueprint $table) {
            $table->string('email')->after('name')->nullable()->unique();
        });
    }

    public function down(): void
    {
        Schema::table('admins', function (Blueprint $table) {
            $table->dropColumn('email');
        });

        Schema::table('agents', function (Blueprint $table) {
            $table->dropColumn('email');
        });
    }
};
