<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('contents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('language_id')->unique()->constrained('languages')->cascadeOnDelete()->cascadeOnUpdate();
            $table->text('calculator_form_title');
            $table->text('calculator_form_entry');
            $table->text('calculator_form_visiting');
            $table->text('calculator_form_travel');
            $table->text('calculator_form_birthday');
            $table->text('calculator_form_cover');
            $table->text('calculator_form_start');
            $table->text('calculator_form_end');
            $table->text('calculator_form_error_end');
            $table->text('calculator_form_error_max');
            $table->text('calculator_form_submit');
            $table->text('calculator_result_deductible');
            $table->text('calculator_result_deductible_tooltip');
            $table->text('calculator_result_unit');
            $table->text('calculator_result_total');
            $table->text('calculator_result_buy');
            $table->text('calculator_result_details');
            $table->text('inquiry_age');
            $table->text('inquiry_cover');
            $table->text('inquiry_days');
            $table->text('inquiry_back');
            $table->text('inquiry_next');
            $table->text('inquiry_step1_title');
            $table->text('inquiry_step1_header');
            $table->text('inquiry_step1_description');
            $table->text('inquiry_step1_agreement');
            $table->text('inquiry_step2_title');
            $table->text('inquiry_step2_basic');
            $table->text('inquiry_step2_family');
            $table->text('inquiry_step2_no');
            $table->text('inquiry_step2_yes');
            $table->text('inquiry_step2_people');
            $table->text('inquiry_step2_cover');
            $table->text('inquiry_step2_address');
            $table->text('inquiry_step2_city');
            $table->text('inquiry_step2_province');
            $table->text('inquiry_step2_postalcode');
            $table->text('inquiry_step2_phone');
            $table->text('inquiry_step2_email');
            $table->text('inquiry_step2_firstname');
            $table->text('inquiry_step2_lastname');
            $table->text('inquiry_step2_gender');
            $table->text('inquiry_step2_male');
            $table->text('inquiry_step2_female');
            $table->text('inquiry_step2_birthday');
            $table->text('inquiry_step2_insured');
            $table->text('inquiry_step2_beneficiaries');
            $table->text('inquiry_step2_alert');
            $table->text('inquiry_step2_policy');
            $table->text('inquiry_step2_start');
            $table->text('inquiry_step2_end');
            $table->text('inquiry_step2_arrival');
            $table->text('inquiry_step2_error_end');
            $table->text('inquiry_step2_error_max');
            $table->text('inquiry_step3_title');
            $table->text('inquiry_step3_fullname');
            $table->text('inquiry_step3_gender');
            $table->text('inquiry_step3_birthday');
            $table->text('inquiry_step3_insured');
            $table->text('inquiry_step3_beneficiaries');
            $table->text('inquiry_step3_policy');
            $table->text('inquiry_step3_start');
            $table->text('inquiry_step3_end');
            $table->text('inquiry_step3_arrival');
            $table->text('inquiry_step3_deductible');
            $table->text('inquiry_step3_unit_total');
            $table->text('inquiry_step3_pay');
            $table->text('inquiry_step3_methods');
            $table->text('inquiry_step3_credit');
            $table->text('inquiry_step3_bank');
            $table->text('inquiry_step3_card_number');
            $table->text('inquiry_step3_card_cvv');
            $table->text('inquiry_step3_card_name');
            $table->text('inquiry_step3_card_expiration');
            $table->text('inquiry_step3_error_card_number');
            $table->text('inquiry_step3_error_plan');
            $table->text('inquiry_step3_transfer');
            $table->text('inquiry_step3_message');
            $table->text('inquiry_step4_title');
            $table->text('inquiry_step4_greeting');
            $table->text('inquiry_step4_message');
            $table->text('inquiry_step4_thanks');
            $table->text('inquiry_step4_back');
            $table->boolean('is_active')->default(1);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contents');
    }
};
