<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('inquiries', function (Blueprint $table) {
            $table->ulid('id')->primary();
            $table->foreignUlid('agent_id')->constrained('agents')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('city_id')->constrained('cities')->cascadeOnDelete()->cascadeOnUpdate();
            $table->unsignedInteger('insurance_cover');
            $table->string('address');
            $table->string('postal_code');
            $table->string('phone');
            $table->string('email');
            $table->string('card_number')->nullable();
            $table->string('card_cvv')->nullable();
            $table->string('card_name')->nullable();
            $table->char('card_expiration', 4)->nullable();
            $table->string('transfer_password')->nullable();
            $table->text('message');
            $table->string('beneficiary_first_name');
            $table->string('beneficiary_last_name');
            $table->dateTime('beneficiary_born_at');
            $table->dateTime('started_at')->useCurrent();
            $table->dateTime('ended_at')->useCurrent();
            $table->dateTime('arrived_at')->useCurrent();
            $table->dateTime('inquired_at')->useCurrent();
            $table->dateTime('reviewed_at')->nullable();
            $table->string('is_beneficiary_male');
            $table->boolean('is_entry')->default(1);
            $table->boolean('is_deal')->default(0);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inquiries');
    }
};
