<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('prices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plan_id')->constrained('plans')->cascadeOnDelete()->cascadeOnUpdate();
            $table->unsignedSmallInteger('age_from');
            $table->unsignedSmallInteger('age_to')->nullable();
            $table->unsignedInteger('insurance_cover');
            $table->double('daily_cost')->unsigned()->nullable();
            $table->boolean('is_entry')->default(1);
            $table->boolean('is_active')->default(1);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prices');
    }
};
