<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('agents', function (Blueprint $table) {
            $table->ulid('id')->primary();
            $table->char('admin_id', 26)->nullable();
            $table->string('username')->unique();
            $table->string('password');
            $table->string('name');
            $table->string('email')->nullable()->unique();
            $table->boolean('is_active')->default(1);

            $table->index('admin_id');
            $table->foreign('admin_id')->references('id')->on('admins')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('agents', function (Blueprint $table) {
            $table->dropForeign(['admin_id']);
            $table->dropIndex(['admin_id']);
        });
        Schema::dropIfExists('agents');
    }
};
