<?php
// config/insurance-rates.php
return [
    'jf' => [
        'non_usa' => [
            'age_brackets' => [
                '0-65' => [
                    '60-64' => 3.80,
                    '65-69' => 4.58,
                    '70-74' => 7.22,
                    '75-79' => 11.42,
                    '80-84' => 18.52,
                    '85-89' => 23.56,
                    '90+' => 28.27,
                ],
                '66-120' => [
                    '60-64' => 4.82,
                    '65-69' => 5.69,
                    '70-74' => 8.71,
                    '75-79' => 12.29,
                    '80-84' => 19.36,
                    '85-89' => 27.75,
                    '90+' => 33.31,
                ],
            ],
        ],
        'usa' => [
            'age_brackets' => [
                '0-65' => [
                    '60-64' => 4.82,
                    '65-69' => 5.81,
                    '70-74' => 8.52,
                    '75-79' => 13.28,
                    '80-84' => 21.60,
                    '85-89' => 28.10,
                    '90+' => 33.72,
                ],
                '66-120' => [
                    '60-64' => 5.04,
                    '65-69' => 6.05,
                    '70-74' => 8.95,
                    '75-79' => 13.61,
                    '80-84' => 21.88,
                    '85-89' => 29.15,
                    '90+' => 34.98,
                ],
            ],
        ],
    ],
    
    'manulife' => [
        'rate_a' => [
            '0-25' => [3.83, 3.89, 3.99, 4.04, 4.06, 4.15, 4.26, 4.62],
            '26-39' => [4.15, 4.21, 4.33, 4.36, 4.42, 4.60, 4.84, 5.14],
            '40-54' => [4.53, 4.65, 4.99, 5.04, 5.23, 5.57, 5.83, 6.25],
            '55-59' => [5.32, 5.40, 5.71, 5.92, 6.14, 6.75, 7.10, 7.63],
            '60-64' => [5.41, 5.79, 6.50, 7.19, 7.44, 7.61, 8.97, 9.25],
            '65-69' => [8.10, 8.15, 9.06, 9.12, 9.49, 9.85, 10.60, 10.64],
            '70-74' => [11.05, 11.10, 11.16, 12.22, 13.45, 13.91, 14.67, 16.53],
            '75-79' => [17.74, 18.23, 19.31, 20.17, 21.77, 23.60, 24.43, 28.11],
            '80-84' => [30.29, 30.54, 30.77, 33.83, 34.18, 35.40, 36.72, 40.41],
            '85+' => [41.36, 41.84, 41.90, 46.03, 46.29, 47.76, 50.45, 53.57],
        ],
        'rate_b' => [
            '60-64' => [9.39, 9.75, 10.32, 10.48, 11.05, 11.10, 12.66, 12.92],
            '65-69' => [11.33, 12.08, 12.39, 13.51, 15.10, 15.53, 16.90, 17.47],
            '70-74' => [15.21, 16.40, 17.14, 17.86, 19.25, 19.64, 23.00, 23.18],
            '75-79' => [25.22, 26.73, 26.73, 27.88, 29.20, 30.68, 33.11, 34.96],
            '80-84' => [46.06, 46.45, 48.48, 48.69, 52.22, 52.35, 52.49, 52.93],
            '85+' => [58.81, 61.18, 62.75, 65.05, 71.19, 74.83, 81.50, 85.14],
        ],
        'rate_c' => [
            '60-64' => [15.63, 16.02, 16.50, 17.35, 17.48, 19.44, 21.45, 23.38],
            '65-69' => [19.51, 20.72, 21.67, 23.09, 24.44, 25.36, 27.78, 30.88],
            '70-74' => [25.97, 26.40, 26.45, 30.27, 31.74, 34.00, 35.66, 39.56],
            '75-79' => [42.12, 46.21, 47.51, 48.94, 49.77, 50.25, 54.11, 59.28],
            '80-84' => [68.99, 71.99, 74.29, 76.11, 81.68, 90.46, 94.06, 105.62],
            '85+' => [93.67, 95.70, 100.35, 105.08, 106.80, 109.66, 110.39, 112.66],
        ],
    ],
    
    'deductible_discounts' => [
        0 => 0,
        500 => 10,
        1000 => 15,
        5000 => 30,
        10000 => 35,
    ],
    
    'questionnaire' => [
        'min_age' => 60,
        'smoking_surcharge_percent' => 10,
    ],
];