<?php

namespace App\Providers\Filament;

use Filament\FontProviders\Contracts\FontProvider;
use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Support\HtmlString;

class IranSansFontProvider implements FontProvider
{
    public function getHtml(string $family, ?string $url = null): Htmlable
    {
        $url ??= url('css/iransans.css');
        return new HtmlString(
            "
            <link href=\"$url\" rel=\"stylesheet\" />
        "
        );
    }
}
