<?php

namespace App\Providers\Filament;

use App\Filament\Pages\Auth\Login;
use App\Filament\Pages\Auth\Profile;
use Closure;
use Exception;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationGroup;
use Filament\Pages\Dashboard;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Tables\Enums\FiltersLayout;
use Filament\Tables\Table;
use Filament\Widgets\AccountWidget;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\HtmlString;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class AgentPanelProvider extends PanelProvider
{
    const INSURANCE = 'Insurance Management';

    public function booted(Closure $callback): void
    {
        parent::booted($callback);
        Model::unguard();
        Table::configureUsing(function (Table $table): void {
            $table
                ->filtersLayout(FiltersLayout::Dropdown)
                ->paginationPageOptions([5, 10, 25, 50])
                ->defaultPaginationPageOption(10);
        });
    }

    /**
     * @throws Exception
     */
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('agent')
            ->path('agent')
            ->globalSearch(false)
            ->defaultAvatarProvider(AvatarProvider::class)
            ->font('IRANSansX', provider: IranSansFontProvider::class)
            ->login(Login::class)
            ->profile(Profile::class, isSimple: false)
            ->revealablePasswords(false)
            ->authGuard('agent')
            ->colors([
                'primary' => Color::Indigo,
            ])
            ->discoverResources(in: app_path('Filament/Agent/Resources'), for: 'App\\Filament\\Agent\\Resources')
            ->discoverPages(in: app_path('Filament/Agent/Pages'), for: 'App\\Filament\\Agent\\Pages')
            ->pages([
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Agent/Widgets'), for: 'App\\Filament\\Agent\\Widgets')
            ->renderHook('panels::scripts.before', fn() => new HtmlString(
                <<<EOT
<script>
    document.addEventListener('DOMContentLoaded', function(){
        setTimeout(() => {
            const activeSidebarItem = document.querySelector('.fi-sidebar-item-active');
            const sidebarWrapper = document.querySelector('.fi-sidebar-nav');
            sidebarWrapper.style.scrollBehavior = 'smooth';
            sidebarWrapper.scrollTo(0, activeSidebarItem.offsetTop - 250);
        }, 300)
    });
</script>
EOT
            ))
            ->widgets([
                AccountWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ])
            ->navigationGroups([
                NavigationGroup::make(self::INSURANCE)->icon('heroicon-o-building-office-2'),
            ]);
    }
}
