<?php

namespace App\Policies;

use App\Models\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Contracts\Auth\Authenticatable;

class InquiryPolicy
{
    use HandlesAuthorization;

    public function viewAny(): bool
    {
        return true;
    }

    public function view(): bool
    {
        return true;
    }

    public function create(): bool
    {
        return false;
    }

    public function update(): bool
    {
        return false;
    }

    public function delete(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function restore(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function forceDelete(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }
}
