<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;

/**
 * Class Session
 * @package App\Models
 *
 * @property string $id
 * @property string $agent_id
 * @property string $token
 * @property string $refresh
 * @property Carbon $expired_at
 * @property bool $is_active
 *
 * @property Agent $agent
 */
class Session extends Model
{
    use HasUlids;

    public $timestamps = false;
    protected $table = 'sessions';
    protected $fillable = [
        'id',
        'agent_id',
        'token',
        'refresh',
        'expired_at',
        'is_active',
    ];

    public function agent(): BelongsTo
    {
        return $this->belongsTo(Agent::class);
    }

    protected function casts(): array
    {
        return [
            'expired_at' => 'datetime',
            'is_active'  => 'boolean',
        ];
    }
}
