<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class ProvinceTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $province_id
 * @property int $language_id
 * @property string $name
 * @property bool $is_active
 *
 * @property Language $language
 * @property Province $province
 */
class ProvinceTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'province_translations';
    protected $fillable = [
        'id',
        'province_id',
        'language_id',
        'name',
        'is_active',
    ];

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    public function province(): BelongsTo
    {
        return $this->belongsTo(Province::class, 'province_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
