<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Province
 * @package App\Models
 *
 * @property int $id
 * @property int $country_id
 * @property string $slug
 * @property bool $is_active
 *
 * @property Collection<City> $cities
 * @property Country $country
 * @property Collection<ProvinceTranslation> $translations
 */
class Province extends Model
{
    public $timestamps = false;
    protected $table = 'provinces';
    protected $fillable = [
        'id',
        'country_id',
        'slug',
        'is_active',
    ];

    public function cities(): HasMany
    {
        return $this->hasMany(City::class, 'province_id');
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function translations(): HasMany
    {
        return $this->hasMany(ProvinceTranslation::class, 'province_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
