<?php

namespace App\Models;

use Carbon\CarbonImmutable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUlids;

class PasswordResetToken extends Model
{
    use HasUlids;

    protected $fillable = [
        'user_type',
        'user_id',
        'email',
        'code',
        'code_hash',
        'expires_at',
        'verified_at',
        'used_at',
    ];

    protected $casts = [
        'expires_at' => 'immutable_datetime',
        'verified_at' => 'immutable_datetime',
        'used_at' => 'immutable_datetime',
    ];

    public function isExpired(): bool
    {
        return $this->expires_at instanceof CarbonImmutable
            ? $this->expires_at->isPast()
            : true;
    }
}
