<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Model
 * @package App\Models
 *
 * @property int $id
 * @property string $code
 * @property string $name
 * @property bool $is_active
 *
 * @property Collection<CityTranslation> $cityTranslations
 * @property Collection<CompanyTranslation> $companyTranslations
 * @property Collection<Content> $contents
 * @property Collection<CountryTranslation> $countryTranslations
 * @property Collection<DeductibleTranslation> $deductibleTranslations
 * @property Collection<ProvinceTranslation> $provinceTranslations
 */
class Language extends Model
{
    public $timestamps = false;
    protected $table = 'languages';
    protected $fillable = [
        'id',
        'code',
        'name',
        'is_active',
    ];

    public function cityTranslations(): HasMany
    {
        return $this->hasMany(CityTranslation::class, 'language_id');
    }

    public function companyTranslations(): HasMany
    {
        return $this->hasMany(CompanyTranslation::class, 'language_id');
    }

    public function contents(): HasMany
    {
        return $this->hasMany(Content::class, 'language_id');
    }

    public function countryTranslations(): HasMany
    {
        return $this->hasMany(CountryTranslation::class, 'language_id');
    }

    public function deductibleTranslations(): HasMany
    {
        return $this->hasMany(DeductibleTranslation::class, 'language_id');
    }

    public function provinceTranslations(): HasMany
    {
        return $this->hasMany(ProvinceTranslation::class, 'language_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
