<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class DeductibleTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $deductible_id
 * @property int $lanauge_id
 * @property string $amount
 * @property string $discount
 * @property bool $is_active
 *
 * @property Deductible $deductible
 * @property Language $language
 */
class DeductibleTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'deductible_translations';
    protected $fillable = [
        'id',
        'deductible_id',
        'language_id',
        'amount',
        'discount',
        'is_active',
    ];

    public function deductible(): BelongsTo
    {
        return $this->belongsTo(Deductible::class, 'deductible_id');
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
