<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class CountryTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $country_id
 * @property int $language_id
 * @property string $name
 * @property bool $is_active
 *
 * @property Country $country
 * @property Language $language
 */
class CountryTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'country_translations';
    protected $fillable = [
        'id',
        'country_id',
        'language_id',
        'name',
        'is_active',
    ];

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class);
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
