<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class CityTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $city_id
 * @property int $language_id
 * @property string $name
 * @property bool $is_active
 *
 * @property City $city
 * @property Language $language
 */
class CityTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'city_translations';
    protected $fillable = [
        'id',
        'city_id',
        'language_id',
        'name',
        'is_active',
    ];

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
