<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class City
 * @package App\Models
 *
 * @property int $id
 * @property int $province_id
 * @property string $slug
 * @property bool $is_active
 *
 * @property Collection<Inquiry> $inquiries
 * @property Province $province
 * @property Collection<CountryTranslation> $translations
 */
class City extends Model
{
    public $timestamps = false;
    protected $table = 'cities';
    protected $fillable = [
        'id',
        'province_id',
        'slug',
        'is_active',
    ];

    public function inquiries(): HasMany
    {
        return $this->hasMany(Inquiry::class, 'city_id');
    }

    public function province(): BelongsTo
    {
        return $this->belongsTo(Province::class, 'province_id');
    }

    public function translations(): HasMany
    {
        return $this->hasMany(CityTranslation::class, 'city_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
