<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PasswordResetCodeMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $name,
        public string $username,
        public string $panelLabel,
        public string $code,
        public int $expiresMinutes,
    ) {
    }

    public function build(): self
    {
        return $this->subject("Your verification code for {$this->panelLabel}")
            ->view('emails.password-reset-code')
            ->with([
                'name' => $this->name,
                'username' => $this->username,
                'panelLabel' => $this->panelLabel,
                'code' => $this->code,
                'expiresMinutes' => $this->expiresMinutes,
            ]);
    }
}
