<?php

namespace App\Http\Resources\Inquiry;

use App\Models\Price;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Price */
class PriceResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'              => $this->id,
            'plan_id'         => $this->plan_id,
            'age_from'        => $this->age_from,
            'age_to'          => $this->age_to,
            'insurance_cover' => $this->insurance_cover,
            'daily_cost'      => $this->daily_cost,
            'is_entry'        => $this->is_entry,
        ];
    }
}
