<?php

namespace App\Http\Resources\Inquiry;

use App\Models\DeductibleTranslation;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin DeductibleTranslation */
class DeductibleTranslationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'             => $this->deductible_id,
            'slug'           => $this->deductible->slug,
            'amount'         => $this->amount,
            'discount'       => $this->discount,
            'amount_value'   => $this->deductible->amount,
            'discount_value' => $this->deductible->discount,
        ];
    }
}
