<?php

namespace App\Http\Resources\Inquiry;

use App\Models\CountryTranslation;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin CountryTranslation */
class CountryTranslationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'     => $this->country_id,
            'name'   => $this->name,
            'prefix' => '+' . $this->country->prefix,
        ];
    }
}
