<?php

namespace App\Http\Resources\Inquiry;

use App\Models\Content;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Content */
class ContentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'calculator_form_title'                => $this->calculator_form_title,
            'calculator_form_entry'                => $this->calculator_form_entry,
            'calculator_form_visiting'             => $this->calculator_form_visiting,
            'calculator_form_travel'               => $this->calculator_form_travel,
            'calculator_form_birthday'             => $this->calculator_form_birthday,
            'calculator_form_cover'                => $this->calculator_form_cover,
            'calculator_form_start'                => $this->calculator_form_start,
            'calculator_form_end'                  => $this->calculator_form_end,
            'calculator_form_error_end'            => $this->calculator_form_error_end,
            'calculator_form_error_max'            => $this->calculator_form_error_max,
            'calculator_form_submit'               => $this->calculator_form_submit,
            'calculator_result_deductible'         => $this->calculator_result_deductible,
            'calculator_result_deductible_tooltip' => $this->calculator_result_deductible_tooltip,
            'calculator_result_unit'               => $this->calculator_result_unit,
            'calculator_result_total'              => $this->calculator_result_total,
            'calculator_result_buy'                => $this->calculator_result_buy,
            'calculator_result_details'            => $this->calculator_result_details,
            'inquiry_age'                          => $this->inquiry_age,
            'inquiry_cover'                        => $this->inquiry_cover,
            'inquiry_days'                         => $this->inquiry_days,
            'inquiry_back'                         => $this->inquiry_back,
            'inquiry_next'                         => $this->inquiry_next,
            'inquiry_step1_title'                  => $this->inquiry_step1_title,
            'inquiry_step1_header'                 => $this->inquiry_step1_header,
            'inquiry_step1_description'            => $this->inquiry_step1_description,
            'inquiry_step1_agreement'              => $this->inquiry_step1_agreement,
            'inquiry_step2_title'                  => $this->inquiry_step2_title,
            'inquiry_step2_basic'                  => $this->inquiry_step2_basic,
            'inquiry_step2_family'                 => $this->inquiry_step2_family,
            'inquiry_step2_no'                     => $this->inquiry_step2_no,
            'inquiry_step2_yes'                    => $this->inquiry_step2_yes,
            'inquiry_step2_people'                 => $this->inquiry_step2_people,
            'inquiry_step2_cover'                  => $this->inquiry_step2_cover,
            'inquiry_step2_address'                => $this->inquiry_step2_address,
            'inquiry_step2_city'                   => $this->inquiry_step2_city,
            'inquiry_step2_province'               => $this->inquiry_step2_province,
            'inquiry_step2_postalcode'             => $this->inquiry_step2_postalcode,
            'inquiry_step2_phone'                  => $this->inquiry_step2_phone,
            'inquiry_step2_email'                  => $this->inquiry_step2_email,
            'inquiry_step2_firstname'              => $this->inquiry_step2_firstname,
            'inquiry_step2_lastname'               => $this->inquiry_step2_lastname,
            'inquiry_step2_gender'                 => $this->inquiry_step2_gender,
            'inquiry_step2_male'                   => $this->inquiry_step2_male,
            'inquiry_step2_female'                 => $this->inquiry_step2_female,
            'inquiry_step2_birthday'               => $this->inquiry_step2_birthday,
            'inquiry_step2_insured'                => $this->inquiry_step2_insured,
            'inquiry_step2_beneficiaries'          => $this->inquiry_step2_beneficiaries,
            'inquiry_step2_alert'                  => $this->inquiry_step2_alert,
            'inquiry_step2_policy'                 => $this->inquiry_step2_policy,
            'inquiry_step2_start'                  => $this->inquiry_step2_start,
            'inquiry_step2_end'                    => $this->inquiry_step2_end,
            'inquiry_step2_arrival'                => $this->inquiry_step2_arrival,
            'inquiry_step2_error_end'              => $this->inquiry_step2_error_end,
            'inquiry_step2_error_max'              => $this->inquiry_step2_error_max,
            'inquiry_step3_title'                  => $this->inquiry_step3_title,
            'inquiry_step3_fullname'               => $this->inquiry_step3_fullname,
            'inquiry_step3_gender'                 => $this->inquiry_step3_gender,
            'inquiry_step3_birthday'               => $this->inquiry_step3_birthday,
            'inquiry_step3_insured'                => $this->inquiry_step3_insured,
            'inquiry_step3_beneficiaries'          => $this->inquiry_step3_beneficiaries,
            'inquiry_step3_policy'                 => $this->inquiry_step3_policy,
            'inquiry_step3_start'                  => $this->inquiry_step3_start,
            'inquiry_step3_end'                    => $this->inquiry_step3_end,
            'inquiry_step3_arrival'                => $this->inquiry_step3_arrival,
            'inquiry_step3_deductible'             => $this->inquiry_step3_deductible,
            'inquiry_step3_unit_total'             => $this->inquiry_step3_unit_total,
            'inquiry_step3_pay'                    => $this->inquiry_step3_pay,
            'inquiry_step3_methods'                => $this->inquiry_step3_methods,
            'inquiry_step3_credit'                 => $this->inquiry_step3_credit,
            'inquiry_step3_bank'                   => $this->inquiry_step3_bank,
            'inquiry_step3_card_number'            => $this->inquiry_step3_card_number,
            'inquiry_step3_card_cvv'               => $this->inquiry_step3_card_cvv,
            'inquiry_step3_card_name'              => $this->inquiry_step3_card_name,
            'inquiry_step3_card_expiration'        => $this->inquiry_step3_card_expiration,
            'inquiry_step3_error_card_number'      => $this->inquiry_step3_error_card_number,
            'inquiry_step3_error_plan'             => $this->inquiry_step3_error_plan,
            'inquiry_step3_transfer'               => $this->inquiry_step3_transfer,
            'inquiry_step3_message'                => $this->inquiry_step3_message,
            'inquiry_step4_title'                  => $this->inquiry_step4_title,
            'inquiry_step4_greeting'               => $this->inquiry_step4_greeting,
            'inquiry_step4_message'                => $this->inquiry_step4_message,
            'inquiry_step4_thanks'                 => $this->inquiry_step4_thanks,
            'inquiry_step4_back'                   => $this->inquiry_step4_back,
        ];
    }
}
