<?php

namespace App\Http\Resources\Inquiry;

use App\Models\CompanyTranslation;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin CompanyTranslation */
class CompanyTranslationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $company = $this->company;
        return [
            'id'          => $this->id,
            'slug'        => $company->slug,
            'logo'        => $company->logo,
            'url'         => $company->url,
            'min_cost'    => $company->min_cost,
            'name'        => $this->name,
            'description' => $this->description,
        ];
    }
}
