<?php

namespace App\Http\Requests\Inquiry;

use Illuminate\Foundation\Http\FormRequest;

class GetSupportedPlansRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'apiKey'          => 'required|string|exists:agents,id',
            'birthdays'       => 'required|string',
            'end_at'          => 'required|string',
            'insurance_cover' => 'required|integer|gt:0',
            'is_entry'        => 'required|boolean',
            'language'        => 'required|string|exists:languages,code',
            'start_at'        => 'required|string',
            'token'           => 'required|string',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'apiKey'          => $this->header('API-Key'),
            'birthdays'       => $this->query('birthdays'),
            'end_at'          => $this->query('end_at'),
            'insurance_cover' => $this->query('insurance_cover'),
            'is_entry'        => $this->query('is_entry'),
            'language'        => $this->header('Accept-Language'),
            'start_at'        => $this->query('start_at'),
            'token'           => $this->bearerToken(),
        ]);
    }
}
