<?php

namespace App\Http\Requests\Authentication;

use Illuminate\Foundation\Http\FormRequest;

class RefreshRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'apiKey' => 'required|string|exists:agents,id',
            'token'  => 'required|string',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'apiKey' => $this->header('API-Key'),
            'token'  => $this->bearerToken(),
        ]);
    }
}
