<?php

namespace App\Http\Requests\Authentication;

use Illuminate\Foundation\Http\FormRequest;

class CheckRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'token'  => 'required|string',
            'apiKey' => 'required|string|exists:agents,id',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'apiKey' => $this->header('API-Key'),
            'token'  => $this->bearerToken(),
        ]);
    }
}
