<?php

namespace App\Http\Actions;

use App\Models\Price;
use Illuminate\Support\Carbon;

class GetSupportedPriceIdsAction
{
    public function run(int $isEntry, int $insuranceCover, array $birthDays): array
    {
        $ages = array_map(
            fn($birthDay) => floor(abs((new Carbon($birthDay))->diffInYears(Carbon::now()))),
            $birthDays
        );
        $priceIds = [];
        foreach ($ages as $age) {
            $priceIds[] = Price::query()
                ->where('age_from', '<=', $age)
                ->where('age_to', '>=', $age)
                ->where([
                    'insurance_cover' => $insuranceCover,
                    'is_entry'        => $isEntry,
                ])
                ->pluck('id')
                ->toArray();
        }
        return array_values(array_intersect(...$priceIds));
    }
}
