<?php

namespace App\Filament\Custom;

use Exception;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\ImageColumn;

class Columns
{
    /**
     * @throws Exception
     */
    public static function image(string $column, string $label, bool $isCircular = false): ImageColumn
    {
        return ImageColumn::make($column)
            ->disk(config('filament.default_filesystem_disk'))
            ->label($label)
            ->circular($isCircular)
            ->extraImgAttributes(['style' => 'border: solid ' . ($isCircular ? 2 : 1) . 'px white']);
    }

    /**
     * @throws Exception
     */
    public static function toggleIcon(string $column = 'is_active', string $label = 'Active'): IconColumn
    {
        return IconColumn::make($column)
            ->label($label)
            ->colors([
                'success' => true,
                'danger'  => false,
            ])
            ->icons([
                'heroicon-o-check-circle' => true,
                'heroicon-o-x-circle'     => false,
            ]);
    }
}
