<?php

namespace App\Filament\Agent\Widgets;

use App\Models\Inquiry;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class PendingInquiries extends StatsOverviewWidget
{
    protected function getStats(): array
    {
        return [
            Stat::make(
                'Pending Inquiries',
                number_format(
                    Inquiry::query()
                        ->where('agent_id', auth()->user()->id)
                        ->whereNull('reviewed_at')
                        ->count()
                )
            ),
        ];
    }
}
