<?php

namespace App\Filament\Agent\Resources\Plans;

use App\Filament\Agent\Resources\Plans\Pages\CreatePlan;
use App\Filament\Agent\Resources\Plans\Pages\EditPlan;
use App\Filament\Agent\Resources\Plans\Pages\ListPlans;
use App\Filament\Agent\Resources\Plans\Schemas\PlanForm;
use App\Filament\Agent\Resources\Plans\Tables\PlansTable;
use App\Models\Plan;
use App\Providers\Filament\AgentPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class PlanResource extends Resource
{
    protected static ?string $model = Plan::class;

    protected static string|UnitEnum|null $navigationGroup = AgentPanelProvider::INSURANCE;

    protected static ?int $navigationSort = 2;

    protected static ?string $recordTitleAttribute = 'slug';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return PlanForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return PlansTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListPlans::route('/'),
            'create' => CreatePlan::route('/create'),
            'edit'   => EditPlan::route('/{record}/edit'),
        ];
    }
}
