<?php

namespace App\Filament\Agent\Resources\Inquiries\Tables;

use App\Filament\Custom\Columns;
use App\Models\Inquiry;
use Exception;
use Filament\Actions\Action;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class InquiriesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('city.slug')
                    ->label('City'),
                TextColumn::make('id')
                    ->label('People Count')
                    ->formatStateUsing(fn(Inquiry $record) => $record->people->count()),
                TextColumn::make('insurance_cover')
                    ->label('Insurance Cover')
                    ->numeric()
                    ->prefix('$'),
                TextColumn::make('started_at')
                    ->label('Days')
                    ->formatStateUsing(fn(Inquiry $record) => $record->started_at->diffInDays($record->ended_at) + 1),
                Columns::toggleIcon('is_entry', 'Entry'),
                Columns::toggleIcon('is_deal', 'Deal'),
            ])
            ->filters([])
            ->recordActions([
                ViewAction::make()->label('')->icon(''),
                Action::make('deal')
                    ->label('Deal')
                    ->icon('heroicon-m-check-circle')
                    ->requiresConfirmation()
                    ->action(fn(Inquiry $record) => $record->update(['reviewed_at' => now(), 'is_deal' => true]))
                    ->visible(fn(Inquiry $record) => is_null($record->reviewed_at) && !$record->is_deal),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
