<?php

namespace App\Filament\Agent\Resources\Inquiries\Schemas;

use App\Filament\Custom\Create;
use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class InquiryForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Hidden::make('agent_id')
                    ->default(auth()->user()->id),
                Create::city()
                    ->required(),
                TextInput::make('insurance_cover')
                    ->label('Insurance Cover')
                    ->required()
                    ->integer()
                    ->minValue(0),
                TextInput::make('address')
                    ->label('Address'),
                TextInput::make('postal_code')
                    ->label('Postal Code'),
                TextInput::make('phone')
                    ->label('Phone'),
                TextInput::make('email')
                    ->label('Email'),
                Section::make('Card')
                    ->columnSpanFull()
                    ->columns(4)
                    ->components([
                        TextInput::make('card_number')
                            ->label('Number'),
                        TextInput::make('card_cvv')
                            ->label('CVV'),
                        TextInput::make('card_name')
                            ->label('Owner Name'),
                        TextInput::make('card_expiration')
                            ->label('Expiration'),
                    ]),
                TextInput::make('transfer_password')
                    ->label('Transfer Password'),
                TextInput::make('message')
                    ->label('Message'),
                Section::make('Residency Dates')
                    ->columns(3)
                    ->components([
                        DatePicker::make('started_at')
                            ->label('Started Date'),
                        DatePicker::make('ended_at')
                            ->label('Ended Date'),
                        DatePicker::make('arrived_at')
                            ->label('Arrived Date'),
                    ]),
                Section::make('Inquiry Dates')
                    ->columns()
                    ->components([
                        DatePicker::make('inquired_at')
                            ->label('Inquired Date'),
                        DatePicker::make('reviewed_at')
                            ->label('Reviewed Date'),
                    ]),
                Checkbox::make('is_entry')
                    ->label('Entry')
                    ->inline(false)
                    ->default(false),
                Checkbox::make('is_deal')
                    ->label('Deal')
                    ->inline(false)
                    ->default(false),
            ]);
    }
}
