<?php

namespace App\Filament\Admin\Resources\Provinces\Schemas;

use App\Filament\Custom\Create;
use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class ProvinceForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Create::country()
                    ->required(),
                TextInput::make('slug')
                    ->unique(ignoreRecord: true)
                    ->required(),
                Checkbox::make('is_active')
                    ->label('Active')
                    ->inline(false)
                    ->default(true),
            ]);
    }
}
