<?php

namespace App\Filament\Admin\Resources\Provinces;

use App\Filament\Admin\Resources\Provinces\Pages\CreateProvince;
use App\Filament\Admin\Resources\Provinces\Pages\EditProvince;
use App\Filament\Admin\Resources\Provinces\Pages\ListProvinces;
use App\Filament\Admin\Resources\Provinces\RelationManagers\TranslationsRelationManager;
use App\Filament\Admin\Resources\Provinces\Schemas\ProvinceForm;
use App\Filament\Admin\Resources\Provinces\Tables\ProvincesTable;
use App\Models\Province;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class ProvinceResource extends Resource
{
    protected static ?string $model = Province::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::LOCATION;

    protected static ?int $navigationSort = 2;

    protected static ?string $recordTitleAttribute = 'slug';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return ProvinceForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return ProvincesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            TranslationsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListProvinces::route('/'),
            'create' => CreateProvince::route('/create'),
            'edit'   => EditProvince::route('/{record}/edit'),
        ];
    }
}
