<?php

namespace App\Filament\Admin\Resources\Deductibles\Schemas;

use App\Filament\Custom\Create;
use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class DeductibleForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Create::company()
                    ->required(),
                TextInput::make('slug')
                    ->unique(ignoreRecord: true)
                    ->required(),
                TextInput::make('amount')
                    ->prefix('$')
                    ->integer()
                    ->minValue(0)
                    ->gte(0)
                    ->required(),
                TextInput::make('discount')
                    ->prefix('%')
                    ->integer()
                    ->minValue(-100)
                    ->maxValue(100)
                    ->gte(-100)
                    ->lte(100)
                    ->required(),
                Checkbox::make('is_active')
                    ->label('Active')
                    ->inline(false)
                    ->default(true),
            ]);
    }
}
