<?php

namespace App\Filament\Admin\Resources\Deductibles;

use App\Filament\Admin\Resources\Deductibles\Pages\CreateDeductible;
use App\Filament\Admin\Resources\Deductibles\Pages\EditDeductible;
use App\Filament\Admin\Resources\Deductibles\Pages\ListDeductibles;
use App\Filament\Admin\Resources\Deductibles\RelationManagers\TranslationsRelationManager;
use App\Filament\Admin\Resources\Deductibles\Schemas\DeductibleForm;
use App\Filament\Admin\Resources\Deductibles\Tables\DeductiblesTable;
use App\Models\Deductible;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class DeductibleResource extends Resource
{
    protected static ?string $model = Deductible::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::INSURANCE;

    protected static ?int $navigationSort = 4;

    protected static ?string $recordTitleAttribute = 'slug';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return DeductibleForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return DeductiblesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            TranslationsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListDeductibles::route('/'),
            'create' => CreateDeductible::route('/create'),
            'edit'   => EditDeductible::route('/{record}/edit'),
        ];
    }
}
