<?php

namespace App\Filament\Admin\Resources\Countries\Schemas;

use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class CountryForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('slug')
                    ->unique(ignoreRecord: true)
                    ->required(),
                TextInput::make('prefix')
                    ->required()
                    ->integer(),
                Checkbox::make('is_active')
                    ->label('Active')
                    ->inline(false)
                    ->default(true),
            ]);
    }
}
