<?php

namespace App\Filament\Admin\Resources\Contents\Schemas;

use Exception;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class ContentForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->columns(1)
            ->components([
                Section::make('Calculator')
                    ->columns()
                    ->components([
                        Section::make('Calculator')
                            ->columnSpan(1)
                            ->components([
                                TextInput::make('calculator_form_title')
                                    ->label('Title')
                                    ->required(),
                                TextInput::make('calculator_form_entry')
                                    ->label('Entry Mode Dropdown Label')
                                    ->required(),
                                TextInput::make('calculator_form_visiting')
                                    ->label('Visiting Entry Mode Value')
                                    ->required(),
                                TextInput::make('calculator_form_travel')
                                    ->label('Travel Entry Mode Value')
                                    ->required(),
                                TextInput::make('calculator_form_birthday')
                                    ->label('Birthday Label')
                                    ->required(),
                                TextInput::make('calculator_form_cover')
                                    ->label('Insurance Cover Dropdown Label')
                                    ->required(),
                                TextInput::make('calculator_form_start')
                                    ->label('Start Date Label')
                                    ->required(),
                                TextInput::make('calculator_form_end')
                                    ->label('End Date Label')
                                    ->required(),
                                TextInput::make('calculator_form_error_end')
                                    ->label('End Date Error Message')
                                    ->required(),
                                TextInput::make('calculator_form_error_max')
                                    ->label('End Date Max Error Message')
                                    ->required(),
                                TextInput::make('calculator_form_submit')
                                    ->label('Submit Button Text')
                                    ->required(),
                            ]),
                        Section::make('Plans')
                            ->columnSpan(1)
                            ->components([
                                TextInput::make('calculator_result_deductible')
                                    ->label('Deductible Column Label')
                                    ->required(),
                                RichEditor::make('calculator_result_deductible_tooltip')
                                    ->label('Deductible Column Tooltip')
                                    ->required(),
                                TextInput::make('calculator_result_unit')
                                    ->label('Unit Cost Column Label')
                                    ->required(),
                                TextInput::make('calculator_result_total')
                                    ->label('Total Cost Column Label')
                                    ->required(),
                                TextInput::make('calculator_result_buy')
                                    ->label('Buy Button Text')
                                    ->required(),
                                TextInput::make('calculator_result_details')
                                    ->label('Details Link Text')
                                    ->required(),
                            ]),
                    ]),
                Section::make('Inquiry')
                    ->columns()
                    ->components([
                        Section::make('Step Wizard')
                            ->columnSpan(1)
                            ->components([
                                TextInput::make('inquiry_step1_title')
                                    ->label('Step 1 Title')
                                    ->required(),
                                TextInput::make('inquiry_step2_title')
                                    ->label('Step 2 Title')
                                    ->required(),
                                TextInput::make('inquiry_step3_title')
                                    ->label('Step 3 Title')
                                    ->required(),
                                TextInput::make('inquiry_step4_title')
                                    ->label('Step 4 Title')
                                    ->required(),
                            ]),
                        Section::make('Header')
                            ->columnSpan(1)
                            ->components([
                                TextInput::make('inquiry_age')
                                    ->label('Age')
                                    ->required(),
                                TextInput::make('inquiry_cover')
                                    ->label('Insurance Cover')
                                    ->required(),
                                TextInput::make('inquiry_days')
                                    ->label('Insurance Days')
                                    ->required(),
                            ]),
                        Section::make('Action Buttons')
                            ->columnSpanFull()
                            ->columns(3)
                            ->components([
                                TextInput::make('inquiry_back')
                                    ->label('Previous Step')
                                    ->required(),
                                TextInput::make('inquiry_next')
                                    ->label('Next Step')
                                    ->required(),
                                TextInput::make('inquiry_step4_back')
                                    ->label('Home')
                                    ->required(),
                            ]),
                        Section::make('Step 1')
                            ->columnSpanFull()
                            ->components([
                                TextInput::make('inquiry_step1_header')
                                    ->label('Header')
                                    ->required(),
                                RichEditor::make('inquiry_step1_description')
                                    ->label('Description')
                                    ->required(),
                                TextInput::make('inquiry_step1_agreement')
                                    ->label('License Agreement')
                                    ->required(),
                            ]),
                        Section::make('Step 2')
                            ->columnSpanFull()
                            ->columns()
                            ->components([
                                TextInput::make('inquiry_step2_basic')
                                    ->label('Basic Information')
                                    ->columnSpanFull()
                                    ->required(),
                                Section::make('Family Plan')
                                    ->columns(3)
                                    ->components([
                                        TextInput::make('inquiry_step2_family')
                                            ->label('Dropdown Label')
                                            ->required(),
                                        TextInput::make('inquiry_step2_no')
                                            ->label('"NO" Value')
                                            ->required(),
                                        TextInput::make('inquiry_step2_yes')
                                            ->label('"YES" Value')
                                            ->required(),
                                    ]),
                                TextInput::make('inquiry_step2_people')
                                    ->label('Number of People Dropdown Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_cover')
                                    ->label('Insurance Cover Dropdown Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_address')
                                    ->label('Address Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_city')
                                    ->label('City Dropdown Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_province')
                                    ->label('Province Dropdown Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_postalcode')
                                    ->label('Postal Code Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_phone')
                                    ->label('Phone Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_email')
                                    ->label('Email Address Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_insured')
                                    ->label('Insured Person Information Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_beneficiaries')
                                    ->label('Beneficiaries Label')
                                    ->required(),
                                Section::make('Person Information')
                                    ->columnSpanFull()
                                    ->columns(3)
                                    ->components([
                                        TextInput::make('inquiry_step2_firstname')
                                            ->label('First Name Input Label')
                                            ->required(),
                                        TextInput::make('inquiry_step2_lastname')
                                            ->label('Last Name Input Label')
                                            ->required(),
                                        TextInput::make('inquiry_step2_birthday')
                                            ->label('Birthday Input Label')
                                            ->required(),
                                        Section::make('Gender')
                                            ->columnSpanFull()
                                            ->columns(3)
                                            ->components([
                                                TextInput::make('inquiry_step2_gender')
                                                    ->label('Dropdown Label')
                                                    ->required(),
                                                TextInput::make('inquiry_step2_male')
                                                    ->label('"MALE" Value')
                                                    ->required(),
                                                TextInput::make('inquiry_step2_female')
                                                    ->label('"FEMALE" Value')
                                                    ->required(),
                                            ]),
                                    ]),
                                RichEditor::make('inquiry_step2_alert')
                                    ->label('Red Alert Message')
                                    ->columnSpanFull()
                                    ->required(),
                                TextInput::make('inquiry_step2_policy')
                                    ->label('Insurance Date Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_start')
                                    ->label('Start Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_end')
                                    ->label('End Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_arrival')
                                    ->label('Arrival Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step2_error_end')
                                    ->label('End Date Error Message')
                                    ->required(),
                                TextInput::make('inquiry_step2_error_max')
                                    ->label('End Date Max Error Message')
                                    ->required(),
                            ]),
                        Section::make('Step 3')
                            ->columnSpanFull()
                            ->columns(3)
                            ->components([
                                TextInput::make('inquiry_step3_fullname')
                                    ->label('Full Name Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_birthday')
                                    ->label('Birthday Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_gender')
                                    ->label('Gender Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_insured')
                                    ->label('Insured Person Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_beneficiaries')
                                    ->label('Beneficiaries Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_policy')
                                    ->label('Insurance Date Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_start')
                                    ->label('Start Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_end')
                                    ->label('End Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_arrival')
                                    ->label('Arrival Date Input Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_deductible')
                                    ->label('Deductible Table Column Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_unit_total')
                                    ->label('Unit / Total Table Column Label')
                                    ->required(),
                                TextInput::make('inquiry_step3_pay')
                                    ->label('Pay Section Label')
                                    ->required(),
                                Section::make('Payment Methods')
                                    ->columnSpanFull()
                                    ->columns(3)
                                    ->components([
                                        TextInput::make('inquiry_step3_methods')
                                            ->label('Dropdown Label')
                                            ->required(),
                                        TextInput::make('inquiry_step3_credit')
                                            ->label('"Credit Card" Value')
                                            ->required(),
                                        TextInput::make('inquiry_step3_bank')
                                            ->label('"Bank Transfer" Value')
                                            ->required(),
                                    ]),
                                Section::make('Card Information')
                                    ->columnSpanFull()
                                    ->columns(4)
                                    ->components([
                                        TextInput::make('inquiry_step3_card_number')
                                            ->label('Card Number Input Label')
                                            ->required(),
                                        TextInput::make('inquiry_step3_card_cvv')
                                            ->label('CVV Input Label')
                                            ->required(),
                                        TextInput::make('inquiry_step3_card_name')
                                            ->label('Card Holder Name Input Label')
                                            ->required(),
                                        TextInput::make('inquiry_step3_card_expiration')
                                            ->label('Card Expiration Input Label')
                                            ->required(),
                                    ]),
                                TextInput::make('inquiry_step3_error_card_number')
                                    ->label('Card Number Error Message')
                                    ->required(),
                                TextInput::make('inquiry_step3_error_plan')
                                    ->label('Plan Error Message')
                                    ->required(),
                                RichEditor::make('inquiry_step3_transfer')
                                    ->label('Bank Transfer Message')
                                    ->required(),
                                TextInput::make('inquiry_step3_message')
                                    ->label('Message Input Label')
                                    ->required(),
                            ]),
                        Section::make('Step 4')
                            ->columnSpanFull()
                            ->columns()
                            ->components([
                                TextInput::make('inquiry_step4_greeting')
                                    ->label('Greeting Label')
                                    ->columnSpanFull()
                                    ->required(),
                                RichEditor::make('inquiry_step4_message')
                                    ->label('Main Message')
                                    ->required(),
                                RichEditor::make('inquiry_step4_thanks')
                                    ->label('Thanks Message')
                                    ->required(),
                            ]),
                    ]),
            ]);
    }
}
