<?php

namespace App\Filament\Admin\Resources\Companies\Schemas;

use App\Filament\Custom\Create;
use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class CompanyForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('slug')
                    ->label('Slug')
                    ->required(),
                Create::image('logo', 'companies')
                    ->label('Logo')
                    ->required(),
                TextInput::make('url')
                    ->label('URL'),
                TextInput::make('min_cost')
                    ->label('Minimum Cost')
                    ->numeric()
                    ->default(0)
                    ->minValue(0)
                    ->gte(0)
                    ->prefix('$')
                    ->required(),
                Checkbox::make('is_active')
                    ->label('Active')
                    ->inline(false)
                    ->default(true),
            ]);
    }
}
