<?php

namespace App\Filament\Admin\Resources\Cities;

use App\Filament\Admin\Resources\Cities\Pages\CreateCity;
use App\Filament\Admin\Resources\Cities\Pages\EditCity;
use App\Filament\Admin\Resources\Cities\Pages\ListCities;
use App\Filament\Admin\Resources\Cities\RelationManagers\TranslationsRelationManager;
use App\Filament\Admin\Resources\Cities\Schemas\CityForm;
use App\Filament\Admin\Resources\Cities\Tables\CitiesTable;
use App\Models\City;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class CityResource extends Resource
{
    protected static ?string $model = City::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::LOCATION;

    protected static ?int $navigationSort = 3;

    protected static ?string $recordTitleAttribute = 'slug';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return CityForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return CitiesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            TranslationsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListCities::route('/'),
            'create' => CreateCity::route('/create'),
            'edit'   => EditCity::route('/{record}/edit'),
        ];
    }
}
