<?php

namespace App\Filament\Admin\Resources\Agents;

use App\Filament\Admin\Resources\Agents\Pages\CreateAgent;
use App\Filament\Admin\Resources\Agents\Pages\EditAgent;
use App\Filament\Admin\Resources\Agents\Pages\ListAgents;
use App\Filament\Admin\Resources\Agents\RelationManagers\InquiriesRelationManager;
use App\Filament\Admin\Resources\Agents\RelationManagers\SessionsRelationManager;
use App\Filament\Admin\Resources\Agents\Schemas\AgentForm;
use App\Filament\Admin\Resources\Agents\Tables\AgentsTable;
use App\Models\Agent;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class AgentResource extends Resource
{
    protected static ?string $model = Agent::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::AGENT;

    protected static ?int $navigationSort = 1;

    protected static ?string $recordTitleAttribute = 'username';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return AgentForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return AgentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            SessionsRelationManager::class,
            InquiriesRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListAgents::route('/'),
            'create' => CreateAgent::route('/create'),
            'edit'   => EditAgent::route('/{record}/edit'),
        ];
    }
}
