<?php

namespace App\Enums;

enum QuestionnaireStep: int
{
    case ELIGIBILITY = 1;     // Step 1: Eligibility check (Manulife)
    case RATE_C_TRIGGER = 2;  // Step 2: Automatic C Rate trigger
    case RATE_B_TRIGGER = 3;  // Step 3: B Rate trigger
    case SMOKING = 4;         // Step 4: Smoking surcharge

    public function label(): string
    {
        return match($this) {
            self::ELIGIBILITY => 'Eligibility Check',
            self::RATE_C_TRIGGER => 'Rate Category C Trigger',
            self::RATE_B_TRIGGER => 'Rate Category B Trigger',
            self::SMOKING => 'Smoking Surcharge',
        };
    }

    public function description(): string
    {
        return match($this) {
            self::ELIGIBILITY => 'Determines if applicant is eligible for insurance',
            self::RATE_C_TRIGGER => 'Questions that automatically trigger Rate Category C',
            self::RATE_B_TRIGGER => 'Questions that trigger Rate Category B',
            self::SMOKING => 'Smoking/vaping history for surcharge calculation',
        };
    }

    public static function getOrderedSteps(): array
    {
        return [
            self::ELIGIBILITY,
            self::RATE_C_TRIGGER,
            self::RATE_B_TRIGGER,
            self::SMOKING,
        ];
    }

    public function nextStep(): ?self
    {
        $steps = self::getOrderedSteps();
        $currentIndex = array_search($this, $steps, true);
        
        return $steps[$currentIndex + 1] ?? null;
    }

    public function previousStep(): ?self
    {
        $steps = self::getOrderedSteps();
        $currentIndex = array_search($this, $steps, true);
        
        return $steps[$currentIndex - 1] ?? null;
    }
}